/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.collections;

import java.util.*;

/**
 * Hash map that refers to values via weak references, thus not
 * keeping them from garbage collection. After a value becomes unreferenced
 * and collected, all the corresponding map entries are removed. (The cleanup
 * is not asynchronous but piggybacks on other map operations). This class
 * is a companion to {@link java.util.WeakHashMap}.
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public class WeakValueHashMap extends WeakValueMap {

    /**
     * Creates new WeakValueHashMap with specified initial capacity and load
     * factor.
     *
     * @see java.util.HashMap(int,float)
     */
    public WeakValueHashMap(int initialCapacity, float loadFactor) {
        super(new HashMap(initialCapacity, loadFactor));
    }

    /**
     * Creates new WeakValueHashMap with specified initial capacity and a
     * default load factor.
     *
     * @see java.util.HashMap(int)
     */
    public WeakValueHashMap(int initialCapacity) {
        super(new HashMap(initialCapacity));
    }

    /**
     * Creates new WeakValueHashMap with a default initial capacity and a
     * default load factor.
     *
     * @see java.util.HashMap(int)
     */
    public WeakValueHashMap() {
        super(new HashMap());
    }

    /**
     * Creates new WeakValueHashMap with specified initial capacity and a
     * default load factor, and copies to it all the mappings from the
     * specified map.
     *
     * @see java.util.HashMap(int)
     */
    public WeakValueHashMap(Map t) {
        super (new HashMap());
        putAll(t);
    }
}
